/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tomcat;

import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.valves.ErrorReportValve;

public class HmcErrorReportValve
extends ErrorReportValve {
    private static final String TRACE_MASKT = "XTOMERVT";
    private static final String TRACE_MASKF = "XTOMERVF";
    private static final String TRACE_MASKD = "XTOMERVD";

    public HmcErrorReportValve() {
        Trace.trace(TRACE_MASKF, "<> HmcErrorReportValve.ctor()");
    }

    public void log(String msg) {
        Trace.trace(TRACE_MASKF, msg);
    }

    public void log(String msg, Throwable t) {
        Trace.trace(TRACE_MASKF, msg);
        Trace.trace(TRACE_MASKF, t);
    }

    public void report(Request request, Response response, Throwable throwable) throws IOException {
        Trace.trace(TRACE_MASKF, "-> HmcErrorReportValve.report");
        if (response instanceof HttpResponse && response instanceof HttpServletResponse) {
            HttpResponse hres = (HttpResponse)response;
            HttpServletResponse hsres = (HttpServletResponse)response;
            Trace.trace(TRACE_MASKF, "response status is: " + hres.getStatus());
            Trace.trace(TRACE_MASKF, "throwable is: " + throwable);
            if (hres.getStatus() >= 400 || throwable != null) {
                Trace.trace(TRACE_MASKF, "building error response...");
                hsres.setContentType("text/html");
                PrintWriter out = hsres.getWriter();
                String msg = RequestUtil.filter((String)hres.getMessage());
                if (msg == null) {
                    msg = "";
                }
                CommonResourceBundle bundle = new CommonResourceBundle();
                Object[] subst = new Object[]{msg, Integer.toString(hres.getStatus()), ""};
                String report = null;
                try {
                    report = sm.getString("http." + hres.getStatus(), (Object)msg);
                    if (report != null) {
                        subst[2] = report;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                out.write(MessageFormat.format(bundle.getString("error.html.start"), subst));
                if (throwable != null) {
                    StringWriter stack = new StringWriter();
                    PrintWriter writer = new PrintWriter(stack);
                    throwable.printStackTrace(writer);
                    subst[0] = stack.toString();
                    out.write(MessageFormat.format(bundle.getString("error.html.stacktrace"), subst));
                    Throwable exc = throwable;
                    while (exc != null) {
                        if (exc instanceof ServletException) {
                            exc = ((ServletException)exc).getRootCause();
                        } else {
                            if (!(exc instanceof JspException)) break;
                            exc = ((JspException)exc).getRootCause();
                        }
                        if (exc == null) continue;
                        stack = new StringWriter();
                        writer = new PrintWriter(stack);
                        exc.printStackTrace(writer);
                        subst[0] = stack.toString();
                        out.write(MessageFormat.format(bundle.getString("error.html.causedby"), subst));
                    }
                }
                out.write(bundle.getString("error.html.end"));
            }
        } else {
            Trace.trace(TRACE_MASKF, "passing report onto super");
            super.report(request, response, throwable);
        }
        Trace.trace(TRACE_MASKF, "<- HmcErrorReportValve.report");
    }
}

